<?php
if(!file_exists('kurlar.xml') || (filemtime('kurlar.xml') < time()-3600))
    file_put_contents('kurlar.xml',
        fopen('http://www.tcmb.gov.tr/kurlar/today.xml', 'r'));
if(!$xml = simplexml_load_file('kurlar.xml'))
    die('XML yüklemede hata oluştu!');
echo <<<HTML
    <html><head><meta charset="utf8"></head><body>
	<table border="1" cellpadding="3" style="border-collapse:collapse">
    <thead><th colspan="9">{$xml['Tarih']}</th></thead>
    <tr>
        <th rowspan="2">Döviz</th>
        <th rowspan="2">Döviz Adı</th>
        <th rowspan="2">Birim</th>
        <th colspan="2">Döviz</th>
        <th colspan="2">Efektif</th>
        <th colspan="2">Çapraz Kur</th>
    </tr>
    <tr>
        <th>Alış</th>
        <th>Satış</th>
        <th>Alış</th>
        <th>Satış</th>
        <th>USD</th>
        <th>EURO</th>
    </tr>
HTML;
foreach($xml->children() as $k) {
    if($k['Kod'] == 'XDR') continue;
    echo <<<HTML
        <tr>
        <td><img src=
        "http://www.tcmb.gov.tr/kurlar/kurlar_tr_dosyalar/images/{$k['Kod']}.gif">
            {$k['Kod']}</td>
        <td>{$k->Isim}</td>
        <td>{$k->Unit}</td>
        <td>{$k->ForexBuying}</td>
        <td>{$k->ForexSelling}</td>
        <td>{$k->BanknoteBuying}</td>
        <td>{$k->BanknoteSelling}</td>
        <td>{$k->CrossRateUSD}</td>
        <td>{$k->CrossRateOther}</td>
        </tr>
HTML;
}
echo '</table></body></html>';